<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['maqtv']) && !isset($_SESSION['userId'])) {
    header('Location: login.php');
    exit();
}

include('connect.php');

if ($conn->connect_error) {
    die('Kết nối database thất bại');
}

$profile = [];
$doituong = isset($_SESSION['doituong']) ? $_SESSION['doituong'] : (isset($_SESSION['maqtv']) ? 'Quản trị viên' : 'Khách hàng');

if ($doituong === 'Quản trị viên') {
    $maqtv = $_SESSION['maqtv'];
    // Truy vấn dữ liệu từ bảng QUANTRIVIEN
    $stmt = $conn->prepare('SELECT MAQTV, HOTEN, EMAIL, SDT, GIOITINH, CCCD, DIACHI FROM QUANTRIVIEN WHERE MAQTV = ?');
    $stmt->bind_param('s', $maqtv);
} else {
    $userId = $_SESSION['userId'];
    // Truy vấn dữ liệu từ bảng USERS
    $stmt = $conn->prepare('SELECT USERID, HOTEN, EMAIL, SDT, GIOITINH, CCCD FROM USERS WHERE USERID = ?');
    $stmt->bind_param('i', $userId);
}

$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows > 0) {
    $profile = $result->fetch_assoc();
}
$stmt->close();

$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $hoten = $_POST['hoten'];
    $sdt = $_POST['sdt'];
    $gioitinh = $_POST['gioitinh'] ?: null;
    $cccd = $_POST['cccd'];
    $diachi = $_POST['diachi'] ?? '';

    $conn->begin_transaction();
    try {
        if ($doituong === 'Quản trị viên') {
            $stmt = $conn->prepare('UPDATE QUANTRIVIEN SET HOTEN = ?, EMAIL = ?, SDT = ?, GIOITINH = ?, CCCD = ?, DIACHI = ? WHERE MAQTV = ?');
            $stmt->bind_param('sssssss', $hoten, $email, $sdt, $gioitinh, $cccd, $diachi, $maqtv);
        } else {
            $stmt = $conn->prepare('UPDATE USERS SET HOTEN = ?, SDT = ?, GIOITINH = ?, CCCD = ?, DIACHI = ? WHERE USERID = ?');
            $stmt->bind_param('sssssi', $hoten, $sdt, $gioitinh, $cccd, $diachi, $userId);
        }
        $stmt->execute();
        $conn->commit();
        $success = 'Cập nhật thông tin thành công!';
        header("Refresh:0"); // Tải lại trang sau khi cập nhật
    } catch (Exception $e) {
        $conn->rollback();
        $error = 'Cập nhật thất bại: ' . $e->getMessage();
    }
    $stmt->close();
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Profile</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Thông tin cá nhân</h1>
    </div>
    <?php if ($doituong === 'Quản trị viên'): ?>
        <?php include('adminNav.php'); ?>
    <?php else: ?>
        <?php include('usersNav.php'); ?>
    <?php endif; ?>
    <div class="profile-container">
        <h2>Thông tin cá nhân</h2>
        <?php if ($doituong === 'Quản trị viên'): ?>
            <div class="profile-item">
                <label>Mã QTV:</label>
                <span><?php echo htmlspecialchars($profile['MAQTV'] ?? ''); ?></span>
            </div>
        <?php else: ?>
            <div class="profile-item">
                <label>Mã KH:</label>
                <span><?php echo htmlspecialchars($profile['USERID'] ?? ''); ?></span>
            </div>
        <?php endif; ?>
        <div class="profile-item">
            <label>Họ tên:</label>
            <span><?php echo htmlspecialchars($profile['HOTEN'] ?? ''); ?></span>
        </div>
        <div class="profile-item">
            <label>Email:</label>
            <span><?php echo htmlspecialchars($profile['EMAIL'] ?? ''); ?></span>
        </div>
        <div class="profile-item">
            <label>SĐT:</label>
            <span><?php echo htmlspecialchars($profile['SDT'] ?? ''); ?></span>
        </div>
        <div class="profile-item">
            <label>Giới tính:</label>
            <span><?php echo htmlspecialchars($profile['GIOITINH'] ?? 'Chưa có'); ?></span>
        </div>
        <div class="profile-item">
            <label>CCCD:</label>
            <span><?php echo htmlspecialchars($profile['CCCD'] ?? ''); ?></span>
        </div>
        <?php if (isset($profile['DIACHI'])): ?>
            <div class="profile-item">
                <label>Địa chỉ:</label>
                <span><?php echo htmlspecialchars($profile['DIACHI'] ?? ''); ?></span>
            </div>
        <?php endif; ?>
        <button class="edit-btn" onclick="document.getElementById('editForm').style.display='block'">Chỉnh sửa</button>
        <form id="editForm" class="form-container" style="display: none;" method="POST" action="">
            <div class="form-group">
                <label for="hoten">Họ tên:</label>
                <input type="text" id="hoten" name="hoten"
                    value="<?php echo htmlspecialchars($profile['HOTEN'] ?? ''); ?>" required>
            </div>
            <div class="form-group">
                <label for="sdt">SĐT:</label>
                <input type="text" id="sdt" name="sdt" value="<?php echo htmlspecialchars($profile['SDT'] ?? ''); ?>"
                    required>
            </div>
            <div class="form-group">
                <label for="gioitinh">Giới tính:</label>
                <select id="gioitinh" name="gioitinh">
                    <option value="Nam" <?php echo ($profile['GIOITINH'] === 'Nam') ? 'selected' : ''; ?>>Nam</option>
                    <option value="Nữ" <?php echo ($profile['GIOITINH'] === 'Nữ') ? 'selected' : ''; ?>>Nữ</option>
                    <option value="">Chưa chọn</option>
                </select>
            </div>
            <div class="form-group">
                <label for="cccd">CCCD:</label>
                <input type="text" id="cccd" name="cccd" value="<?php echo htmlspecialchars($profile['CCCD'] ?? ''); ?>"
                    required>
            </div>
            <?php if (isset($profile['DIACHI'])): ?>
                <div class="form-group">
                    <label for="diachi">Địa chỉ:</label>
                    <textarea id="diachi" name="diachi"
                        required><?php echo htmlspecialchars($profile['DIACHI'] ?? ''); ?></textarea>
                </div>
            <?php endif; ?>
            <div class="form-group">
                <input type="submit" value="Lưu thay đổi">
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
            <?php if ($success): ?>
                <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>

</html>