<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $conn = new mysqli($hostname, $username, $password, $dbname);
    if ($conn->connect_error) {
        $error = 'Kết nối database thất bại';
    } else {
        $email = $_POST['email'];
        $password = $_POST['password'];

        // Kiểm tra đăng nhập cho Khách hàng (USERS)
        $stmtUser = $conn->prepare('SELECT USERID, EMAIL, MATKHAU FROM USERS WHERE EMAIL = ?');
        $stmtUser->bind_param('s', $email);
        $stmtUser->execute();
        $resultUser = $stmtUser->get_result();
        if ($resultUser->num_rows > 0) {
            $user = $resultUser->fetch_assoc();
            if (password_verify($password, $user['MATKHAU'])) {
                $_SESSION['userId'] = $user['USERID'];
                $_SESSION['doituong'] = 'Khách hàng';
                header('Location: khachHang.php');
                exit();
            }
        }

        // Kiểm tra đăng nhập cho Quản trị viên
        $stmtQTV = $conn->prepare('SELECT MAQTV, EMAIL, MATKHAU FROM QUANTRIVIEN WHERE EMAIL = ?');
        $stmtQTV->bind_param('s', $email);
        $stmtQTV->execute();
        $resultQTV = $stmtQTV->get_result();
        if ($resultQTV->num_rows > 0) {
            $qtv = $resultQTV->fetch_assoc();
            if (password_verify($password, $qtv['MATKHAU'])) {
                $_SESSION['maqtv'] = $qtv['MAQTV'];
                $_SESSION['doituong'] = 'Quản trị viên';
                header('Location: admin.php');
                exit();
            }
        }

        $error = 'Tên đăng nhập hoặc mật khẩu không đúng';
        $stmtUser->close();
        $stmtQTV->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Đăng nhập</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Đăng nhập</h1>
    </div>
    <div class="form-container">
        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="password">Mật khẩu:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <input type="submit" value="Đăng nhập">
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>

</html>