<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['maqtv'])) {
    header('Location: login.php');
    exit();
}

include 'connect.php';

$result = $conn->query('SELECT l.LICHLAMVIECID, l.CA, l.THOIGIANBATDAU, l.THOIGIANKETTHUC, n.NHANVIENID FROM LICHLAMVIEC l JOIN NHANVIEN n ON l.LICHLAMVIECID = n.LICHLAMVIECID');
$conn->close();
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Danh sách việc cần làm</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Danh sách việc cần làm</h1>
    </div>
    <?php include('adminNav.php'); ?>
    <div class="admin-container">
        <table>
            <tr>
                <th>Mã lịch</th>
                <th>Ca làm</th>
                <th>Thời gian bắt đầu</th>
                <th>Thời gian kết thúc</th>
                <th>Mã nhân viên</th>
            </tr>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?php echo htmlspecialchars($row['LICHLAMVIECID']); ?></td>
                    <td><?php echo htmlspecialchars($row['CA']); ?></td>
                    <td><?php echo htmlspecialchars($row['THOIGIANBATDAU']); ?></td>
                    <td><?php echo htmlspecialchars($row['THOIGIANKETTHUC']); ?></td>
                    <td><?php echo htmlspecialchars($row['NHANVIENID']); ?></td>
                </tr>
            <?php endwhile; ?>
        </table>
    </div>
</body>

</html>
```