<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['userId']) || !isset($_SESSION['pending_registration'])) {
    header('Location: login.php');
    exit();
}

$error = $success = '';
$userId = $_SESSION['userId'];
$registration = $_SESSION['pending_registration'];

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$conn = new mysqli($hostname, $username, $password, $dbname);
if ($conn->connect_error) {
    $error = 'Kết nối database thất bại: ' . $conn->connect_error;
    error_log("Connection error: " . $conn->connect_error);
} else {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $phuongThuc = $_POST['phuongThuc'];
        $tongGiaVe = $registration['tongGiaVe'];

        $conn->begin_transaction();
        try {
            // Chèn vào bảng VEXE trước để tạo VEID
            $stmt = $conn->prepare('INSERT INTO VEXE (USERID, XEID, GOIVE, TONGGIAVE, THOIGIANDAT, THOIGIANHETHAN) VALUES (?, ?, ?, ?, ?, ?)');
            if ($stmt === false) {
                throw new Exception('Lỗi prepare insert VEXE: ' . $conn->error);
            }
            $stmt->bind_param('iissss', $userId, $registration['xeId'], $registration['goiVe'], $tongGiaVe, $registration['thoiGianDat'], $registration['thoiGianHetHan']);
            if (!$stmt->execute()) {
                throw new Exception('Lỗi execute VEXE: ' . $stmt->error);
            }
            $veId = $conn->insert_id;
            $stmt->close();

            // Chèn vào bảng HOADON với VEID vừa tạo
            $stmt = $conn->prepare('INSERT INTO HOADON (VEID, PHUONGTHUCTHANHTOAN, TONGGIATIEN) VALUES (?, ?, ?)');
            if ($stmt === false) {
                throw new Exception('Lỗi prepare insert HOADON: ' . $conn->error);
            }
            $stmt->bind_param('isd', $veId, $phuongThuc, $tongGiaVe);
            if (!$stmt->execute()) {
                throw new Exception('Lỗi execute HOADON: ' . $stmt->error);
            }
            $stmt->close();

            $conn->commit();

            // Xóa thông tin tạm thời khỏi session
            unset($_SESSION['pending_registration']);
            $success = 'Thanh toán thành công!';
            header("Location: dsTheXe.php?userId=$userId");
            exit();
        } catch (Exception $e) {
            $conn->rollback();
            $error = 'Thanh toán thất bại: ' . $e->getMessage();
            error_log("Transaction error: " . $e->getMessage());
        }
    }
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Thanh toán hóa đơn</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Thanh toán hóa đơn</h1>
    </div>
    <?php include('usersNav.php'); ?>
    <div class="form-container">
        <?php if ($error): ?>
            <p class="error"><?php echo htmlspecialchars($error); ?></p>
        <?php elseif (isset($registration)): ?>
            <p>Xe ID: <?php echo htmlspecialchars($registration['xeId']); ?></p>
            <p>Gói vé: <?php echo htmlspecialchars($registration['goiVe']); ?></p>
            <p>Tổng giá: <?php echo number_format($registration['tongGiaVe'], 2); ?> VND</p>
            <form method="POST" action="">
                <div class="form-group">
                    <label for="phuongThuc">Phương thức thanh toán:</label>
                    <select id="phuongThuc" name="phuongThuc" required>
                        <option value="Tiền mặt">Tiền mặt</option>
                        <option value="Momo">Momo</option>
                        <option value="Chuyển khoản">Chuyển khoản</option>
                    </select>
                </div>
                <div class="form-group">
                    <input type="submit" value="Thanh toán">
                </div>
            </form>
        <?php endif; ?>
        <?php if ($success): ?>
            <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
        <?php endif; ?>
    </div>
</body>

</html>