<!-- Trang này dùng để mã hóa mật khẩu khi tạo users/admin trong SQL -->

<?php
$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $conn = new mysqli($hostname, $username, $password, $dbname);
    if ($conn->connect_error) {
        $error = 'Kết nối database thất bại';
    } else {
        $email = $_POST['email'];
        $newPassword = password_hash($_POST['password'], PASSWORD_DEFAULT);

        $conn->begin_transaction();
        try {
            $stmt = $conn->prepare('UPDATE QUANTRIVIEN SET MATKHAU = ? WHERE EMAIL = ?');
            $stmt->bind_param('ss', $newPassword, $email);
            $stmt->execute();
            if ($stmt->affected_rows > 0) {
                $success = 'Mật khẩu đã được mã hóa và cập nhật thành công!';
            } else {
                $error = 'Không tìm thấy email trong database.';
            }
            $conn->commit();
        } catch (Exception $e) {
            $conn->rollback();
            $error = 'Lỗi khi cập nhật mật khẩu: ' . $e->getMessage();
        }
        $stmt->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Mã hóa mật khẩu</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="header">
        <h1>Mã hóa mật khẩu</h1>
    </div>
    <div class="form-container">
        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="password">Mật khẩu mới:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <input type="submit" value="Mã hóa và cập nhật">
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
            <?php if ($success): ?>
                <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>