<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['userId'])) {
    header('Location: login.php');
    exit();
}

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$error = $success = '';
$userId = $_SESSION['userId'];
$conn = new mysqli($hostname, $username, $password, $dbname);
if ($conn->connect_error) {
    $error = 'Kết nối database thất bại';
} else {
    // Kiểm tra và xóa các vé đã hết hạn
    $currentTime = date('Y-m-d H:i:s');
    $stmtDelete = $conn->prepare('DELETE FROM VEXE WHERE USERID = ? AND THOIGIANHETHAN <= ?');
    $stmtDelete->bind_param('is', $userId, $currentTime);
    if (!$stmtDelete->execute()) {
        error_log("Error deleting expired tickets: " . $stmtDelete->error);
    }
    $stmtDelete->close();

    // Kiểm tra thông báo thành công từ dkTheGiuXe.php
    if (isset($_GET['userId']) && $userId == $_GET['userId']) {
        $success = 'Đăng ký thẻ giữ xe thành công!';
    }

    // Lấy danh sách thẻ giữ xe của khách hàng
    $stmt = $conn->prepare('SELECT V.VEID, V.GOIVE, V.TONGGIAVE, V.THOIGIANDAT, V.THOIGIANHETHAN, X.BIENSOXE, X.LOAIXE 
                           FROM VEXE V 
                           JOIN XE X ON V.XEID = X.XEID 
                           WHERE V.USERID = ?');
    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    $theXe = $result->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Danh sách thẻ xe</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Danh sách thẻ xe</h1>
    </div>
    <?php include('usersNav.php'); ?>
    <div class="form-container">
        <?php if ($error): ?>
            <p class="error"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <?php if ($success): ?>
            <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
        <?php endif; ?>

        <?php if (empty($theXe)): ?>
            <p>Bạn chưa có thẻ giữ xe nào. Vui lòng đăng ký tại <a href="dangKyXe.php">đây</a>.</p>
        <?php else: ?>
            <table class="the-xe-table">
                <thead>
                    <tr>
                        <th>Mã thẻ</th>
                        <th>Biển số xe</th>
                        <th>Loại xe</th>
                        <th>Gói vé</th>
                        <th>Giá vé</th>
                        <th>Thời gian đặt</th>
                        <th>Ngày hết hạn</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($theXe as $the): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($the['VEID']); ?></td>
                            <td><?php echo htmlspecialchars($the['BIENSOXE']); ?></td>
                            <td><?php echo htmlspecialchars($the['LOAIXE']); ?></td>
                            <td><?php echo ucfirst(htmlspecialchars($the['GOIVE'])); ?> (1
                                <?php echo ($the['GOIVE'] === 'ngay') ? 'ngày' : 'tháng'; ?>)
                            </td>
                            <td><?php echo number_format($the['TONGGIAVE'], 0, ',', '.'); ?> VNĐ</td>
                            <td><?php echo htmlspecialchars($the['THOIGIANDAT']); ?></td>
                            <td><?php echo htmlspecialchars($the['THOIGIANHETHAN']); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</body>

</html>