<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['maqtv'])) {
    header('Location: login.php');
    exit();
}

include('connect.php');

$error = $success = '';
$maQtv = $_SESSION['maqtv'];

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

// Kết nối database
$conn = new mysqli($hostname, $username, $password, $dbname);
if ($conn->connect_error) {
    $error = 'Kết nối database thất bại: ' . $conn->connect_error;
} else {
    $result = $conn->query('SELECT n.NHANVIENID, n.DIACHI, n.NGAYTUYENDUNG, n.LUONG, t.SOTHE, t.NGAYCAP, t.TRANGTHAI FROM NHANVIEN n LEFT JOIN THENHANVIEN t ON n.NHANVIENID = t.NHANVIENID');
    if (!$result) {
        $error = 'Lỗi truy vấn: ' . $conn->error;
    }

    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['edit_nhanvienid'])) {
        $nhanvienid = $_POST['edit_nhanvienid'];
        $diachi = $_POST['diachi'];
        $luong = $_POST['luong'];
        $sothe = $_POST['sothe'] ?? null;
        $ngaycap = $_POST['ngaycap'] ?? null;
        $trangthai = $_POST['trangthai'] ?? 'Chưa có';

        $conn->begin_transaction();
        try {
            // Cập nhật bảng NHANVIEN
            $stmt = $conn->prepare('UPDATE NHANVIEN SET DIACHI = ?, LUONG = ? WHERE NHANVIENID = ?');
            $stmt->bind_param('sds', $diachi, $luong, $nhanvienid);
            $stmt->execute();

            // Cập nhật hoặc chèn vào THENHANVIEN
            if ($sothe || $ngaycap || $trangthai !== 'Chưa có') {
                $stmt = $conn->prepare('INSERT INTO THENHANVIEN (NHANVIENID, SOTHE, NGAYCAP, TRANGTHAI) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE SOTHE = ?, NGAYCAP = ?, TRANGTHAI = ?');
                $stmt->bind_param('issssss', $nhanvienid, $sothe, $ngaycap, $trangthai, $sothe, $ngaycap, $trangthai);
                $stmt->execute();
            }
            $conn->commit();
            $success = 'Cập nhật thông tin nhân viên thành công!';
            header("Refresh:0");
        } catch (Exception $e) {
            $conn->rollback();
            $error = 'Cập nhật thất bại: ' . $e->getMessage();
        }
        $stmt->close();
    }
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Danh sách nhân viên</title>
    <link rel="stylesheet" href="styles.css">
    <style>
        .edit-form {
            display: none;
            margin-top: 10px;
        }

        .edit-btn {
            margin-left: 10px;
        }
    </style>
    <script>
        function showEditForm(nhanvienid, diachi, luong, sothe, ngaycap, trangthai) {
            const form = document.getElementById('editForm_' + nhanvienid);
            form.style.display = 'block';
            form.querySelector('#edit_diachi').value = diachi;
            form.querySelector('#edit_luong').value = luong;
            form.querySelector('#edit_sothe').value = sothe || '';
            form.querySelector('#edit_ngaycap').value = ngaycap || '';
            form.querySelector('#edit_trangthai').value = trangthai;
        }
    </script>
</head>

<body>
    <div class="header">
        <h1>Danh sách nhân viên</h1>
    </div>
    <?php include('adminNav.php'); ?>
    <div class="admin-container">
        <?php if ($error): ?>
            <p class="error"><?php echo htmlspecialchars($error); ?></p>
        <?php endif; ?>
        <?php if ($success): ?>
            <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
        <?php endif; ?>
        <?php if (!$error): ?>
            <table>
                <tr>
                    <th>Mã nhân viên</th>
                    <th>Địa chỉ</th>
                    <th>Ngày tuyển dụng</th>
                    <th>Lương</th>
                    <th>Số thẻ</th>
                    <th>Ngày cấp</th>
                    <th>Trạng thái</th>
                    <th>Hành động</th>
                </tr>
                <?php if ($result && $result->num_rows > 0): ?>
                    <?php while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?php echo htmlspecialchars($row['NHANVIENID']); ?></td>
                            <td><?php echo htmlspecialchars($row['DIACHI']); ?></td>
                            <td><?php echo htmlspecialchars($row['NGAYTUYENDUNG']); ?></td>
                            <td><?php echo htmlspecialchars($row['LUONG']); ?></td>
                            <td><?php echo htmlspecialchars($row['SOTHE'] ?? 'Chưa có'); ?></td>
                            <td><?php echo htmlspecialchars($row['NGAYCAP']); ?></td>
                            <td><?php echo htmlspecialchars($row['TRANGTHAI']); ?></td>
                            <td>
                                <button class="edit-btn"
                                    onclick="showEditForm('<?php echo $row['NHANVIENID']; ?>', '<?php echo htmlspecialchars($row['DIACHI']); ?>', '<?php echo htmlspecialchars($row['LUONG']); ?>', '<?php echo htmlspecialchars($row['SOTHE'] ?? ''); ?>', '<?php echo htmlspecialchars($row['NGAYCAP'] ?? ''); ?>', '<?php echo htmlspecialchars($row['TRANGTHAI'] ?? ''); ?>')">Chỉnh
                                    sửa</button>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="8">
                                <form id="editForm_<?php echo $row['NHANVIENID']; ?>" class="edit-form" method="POST" action="">
                                    <input type="hidden" name="edit_nhanvienid" value="<?php echo $row['NHANVIENID']; ?>">
                                    <div class="form-group">
                                        <label for="edit_diachi">Địa chỉ:</label>
                                        <input type="text" id="edit_diachi" name="diachi" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_luong">Lương:</label>
                                        <input type="number" id="edit_luong" name="luong" step="0.01" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_sothe">Số thẻ:</label>
                                        <input type="text" id="edit_sothe" name="sothe">
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_ngaycap">Ngày cấp:</label>
                                        <input type="date" id="edit_ngaycap" name="ngaycap">
                                    </div>
                                    <div class="form-group">
                                        <label for="edit_trangthai">Trạng thái:</label>
                                        <select id="edit_trangthai" name="trangthai">
                                            <option value="Hoạt động">Hoạt động</option>
                                            <option value="Hết hiệu lực">Hết hiệu lực</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <input type="submit" value="Lưu thay đổi">

                                    </div>
                                </form>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="8">Không có dữ liệu nhân viên.</td>
                    </tr>
                <?php endif; ?>
            </table>
        <?php endif; ?>
    </div>
</body>

</html>