<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
if (!isset($_SESSION['maqtv'])) {
    header('Location: login.php');
    exit();
}

include 'connect.php';

$dailyRevenue = [];
$currentDate = date('Y-m-d');

// Lấy doanh thu của 7 ngày gần nhất, sắp xếp tăng dần (từ ngày hiện tại về trước)
for ($i = 0; $i <= 6; $i++) {
    $date = date('Y-m-d', strtotime("-$i days", strtotime($currentDate)));
    $result = $conn->query("SELECT SUM(TONGGIATIEN) as total_revenue FROM HOADON WHERE DATE(THOIGIANXUAT) = '$date'");
    $row = $result->fetch_assoc();
    $dailyRevenue[$date] = $row['total_revenue'] ?? 0;
}
$conn->close();
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Doanh thu</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Doanh thu</h1>
    </div>
    <?php include('adminNav.php'); ?>
    <div class="admin-container">
        <h2>Doanh thu hằng ngày (7 ngày gần nhất)</h2>
        <table>
            <tr>
                <th>Ngày</th>
                <th>Doanh thu (VND)</th>
            </tr>
            <?php
            // Sắp xếp tăng dần theo ngày (từ ngày hiện tại về trước)
            krsort($dailyRevenue); // Sắp xếp mảng theo khóa (ngày) giảm dần
            foreach ($dailyRevenue as $date => $revenue):
                ?>
                <tr>
                    <td><?php echo date('d/m/Y', strtotime($date)); ?></td>
                    <td><?php echo number_format($revenue, 2); ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
    </div>
</body>

</html>