<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['userId'])) {
    header('Location: login.php');
    exit();
}

$error = $success = '';
$userId = $_SESSION['userId'];

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$conn = new mysqli($hostname, $username, $password, $dbname);
if ($conn->connect_error) {
    $error = 'Kết nối database thất bại: ' . $conn->connect_error;
} else {
    $availableXes = [];
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $goiVe = $_POST['goiVe'];
        $xeId = (int) $_POST['xeId'];

        // Kiểm tra xe có tồn tại và thuộc về người dùng
        $stmt = $conn->prepare('SELECT LOAIXE FROM XE WHERE XEID = ? AND EXISTS (SELECT 1 FROM USER_XE WHERE USERID = ? AND XEID = ?)');
        $stmt->bind_param('iii', $xeId, $userId, $xeId);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows > 0) {
            $xe = $result->fetch_assoc();
            $loaiXe = $xe['LOAIXE'];

            // Tính tổng giá vé dựa trên loại xe và gói vé
            $tongGiaVe = 0;
            if ($loaiXe === 'Ô tô') {
                $tongGiaVe = ($goiVe === 'ngay') ? 40000 : 1000000;
            } elseif ($loaiXe === 'Mô tô') {
                $tongGiaVe = ($goiVe === 'ngay') ? 5000 : 120000;
            }

            $thoiGianDat = date('Y-m-d H:i:s');
            $thoiGianHetHan = date('Y-m-d H:i:s', strtotime($thoiGianDat . ($goiVe === 'ngay' ? ' +24 hours' : ' +30 days')));

            // Lưu thông tin tạm thời vào session thay vì chèn vào VEXE
            $_SESSION['pending_registration'] = [
                'userId' => $userId,
                'xeId' => $xeId,
                'goiVe' => $goiVe,
                'tongGiaVe' => $tongGiaVe,
                'thoiGianDat' => $thoiGianDat,
                'thoiGianHetHan' => $thoiGianHetHan
            ];
            header("Location: hoaDon.php");
            exit();
        } else {
            $error = 'Xe không tồn tại hoặc không thuộc về bạn.';
        }
        $stmt->close();
    }

    // Lấy danh sách xe đã đăng ký của người dùng
    $stmt = $conn->prepare('SELECT XE.XEID, XE.BIENSOXE, XE.LOAIXE FROM XE WHERE EXISTS (SELECT 1 FROM USER_XE WHERE USERID = ? AND XEID = XE.XEID)');
    $stmt->bind_param('i', $userId);
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $availableXes[$row['XEID']] = $row['BIENSOXE'] . ' (' . $row['LOAIXE'] . ')';
    }
    $stmt->close();

    // Debug: Kiểm tra số lượng xe tìm thấy
    if (empty($availableXes)) {
        error_log("No vehicles found for userId: $userId. Checking USER_XE table.");
        $debugStmt = $conn->prepare('SELECT * FROM USER_XE WHERE USERID = ?');
        $debugStmt->bind_param('i', $userId);
        $debugStmt->execute();
        $debugResult = $debugStmt->get_result();
        if ($debugResult->num_rows == 0) {
            error_log("No entries in USER_XE for userId: $userId");
        } else {
            error_log("USER_XE entries for userId: $userId: " . print_r($debugResult->fetch_all(MYSQLI_ASSOC), true));
        }
        $debugStmt->close();
    }
    $conn->close();
}
?>

<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Đăng ký thẻ giữ xe</title>
    <link rel="stylesheet" href="styles.css">
</head>
<body>
    <div class="header">
        <h1>Đăng ký thẻ giữ xe</h1>
    </div>
    <?php include('usersNav.php'); ?>
    <div class="form-container">
        <form method="POST" action="">
            <?php if (empty($availableXes)): ?>
                <p class="error">Bạn chưa đăng ký xe nào. Vui lòng đăng ký xe tại <a href="dangKyXe.php">đây</a>.</p>
            <?php else: ?>
                <div class="form-group">
                    <label for="xeId">Chọn xe:</label>
                    <select id="xeId" name="xeId" required>
                        <?php foreach ($availableXes as $id => $bienSo): ?>
                            <option value="<?php echo $id; ?>"><?php echo htmlspecialchars($bienSo); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label for="goiVe">Chọn gói vé:</label>
                    <select id="goiVe" name="goiVe" required>
                        <option value="ngay">Ngày (1 ngày)</option>
                        <option value="thang">Tháng (1 tháng)</option>
                    </select>
                </div>
                <div class="form-group">
                    <input type="submit" value="Đăng ký">
                </div>
            <?php endif; ?>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
            <?php if ($success): ?>
                <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>
</html>