<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['userId'])) {
    header('Location: login.php');
    exit();
}

$error = $success = '';
$userId = $_SESSION['userId'];

$hostname = "localhost";
$username = "root";
$password = "";
$dbname = "qlbaidoxe";

$conn = new mysqli($hostname, $username, $password, $dbname);
if ($conn->connect_error) {
    $error = 'Kết nối database thất bại';
} else {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        $loaiXe = $_POST['loaiXe'];
        $hangXe = $_POST['hangXe'];
        $bienSoXe = $_POST['bienSoXe'];

        $conn->begin_transaction();
        $stmtCheck = null;
        $stmtXe = null;
        $stmtUserXe = null;
        try {
            // Kiểm tra trùng lặp BIENSOXE
            $stmtCheck = $conn->prepare('SELECT COUNT(*) FROM XE WHERE BIENSOXE = ?');
            $stmtCheck->bind_param('s', $bienSoXe);
            $stmtCheck->execute();
            $resultCheck = $stmtCheck->get_result();
            $count = $resultCheck->fetch_row()[0];
            if ($count > 0) {
                throw new Exception('Biển số xe đã tồn tại. Vui lòng chọn biển số khác!');
            }

            // Chèn vào XE
            $stmtXe = $conn->prepare('INSERT INTO XE (LOAIXE, HANGXE, BIENSOXE) VALUES (?, ?, ?)');
            $stmtXe->bind_param('sss', $loaiXe, $hangXe, $bienSoXe);
            $stmtXe->execute();
            $xeId = $conn->insert_id;

            // Liên kết USERID và XEID trong USER_XE
            $stmtUserXe = $conn->prepare('INSERT INTO USER_XE (USERID, XEID) VALUES (?, ?)');
            $stmtUserXe->bind_param('ii', $userId, $xeId);
            $stmtUserXe->execute();

            $conn->commit();
            $success = 'Đăng ký xe thành công! Bạn sẽ được chuyển đến trang đăng ký thẻ giữ xe.';
            header("Refresh:2; url=dkTheGiuXe.php?xeId=$xeId");
        } catch (Exception $e) {
            $conn->rollback();
            $error = $e->getMessage();
        }

        if ($stmtCheck)
            $stmtCheck->close();
        if ($stmtXe)
            $stmtXe->close();
        if ($stmtUserXe)
            $stmtUserXe->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Đăng ký xe</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Đăng ký xe</h1>
    </div>
    <?php include('usersNav.php'); ?>
    <div class="form-container">
        <form method="POST" action="">
            <div class="form-group">
                <label for="bienSoXe">Biển số xe:</label>
                <input type="text" id="bienSoXe" name="bienSoXe" required>
            </div>
            <div class="form-group">
                <label for="loaiXe">Loại xe:</label>
                <select id="loaiXe" name="loaiXe" required>
                    <option value="Ô tô">Ô tô</option>
                    <option value="Mô tô">Mô tô</option>
                </select>
            </div>
            <div class="form-group">
                <label for="hangXe">Hãng xe:</label>
                <input type="text" id="hangXe" name="hangXe" required>
            </div>
            <div class="form-group">
                <input type="submit" value="Đăng ký xe">
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
            <?php if ($success): ?>
                <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>

</html>