<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['maqtv'])) {
    header('Location: login.php');
    exit();
}

$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $hostname = "localhost";
    $username = "root";
    $password = "";
    $dbname = "qlbaidoxe";

    $conn = new mysqli($hostname, $username, $password, $dbname);
    if ($conn->connect_error) {
        $error = 'Kết nối database thất bại';
    } else {
        $email = $_POST['email'];
        $password = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $hoten = $_POST['hoten'];
        $sdt = $_POST['sdt'];
        $gioitinh = $_POST['gioitinh'] ?: null;
        $cccd = $_POST['cccd'];
        $diachi = $_POST['diachi'] ?? '';

        $conn->begin_transaction();
        try {
            // Kiểm tra trùng lặp email, sdt, cccd trên USERS
            $stmtCheck = $conn->prepare('SELECT COUNT(*) FROM USERS WHERE EMAIL = ? OR SDT = ? OR CCCD = ?');
            $stmtCheck->bind_param('sss', $email, $sdt, $cccd);
            $stmtCheck->execute();
            $resultCheck = $stmtCheck->get_result();
            if ($resultCheck->fetch_row()[0] > 0) {
                throw new Exception('Email, SĐT hoặc CCCD đã tồn tại.');
            }

            // Chèn vào USERS (không cần XEID ngay lập tức)
            $stmt = $conn->prepare('INSERT INTO USERS (EMAIL, MATKHAU, HOTEN, SDT, GIOITINH, CCCD) VALUES (?, ?, ?, ?, ?, ?)');
            $stmt->bind_param('ssssss', $email, $password, $hoten, $sdt, $gioitinh, $cccd);
            $stmt->execute();

            $conn->commit();
            $success = 'Đăng ký tài khoản khách hàng thành công!';
        } catch (Exception $e) {
            $conn->rollback();
            $error = 'Đăng ký thất bại: ' . $e->getMessage();
        }
        $stmt->close();
        $conn->close();
    }
}
?>

<!DOCTYPE html>
<html lang="vi">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Đăng ký tài khoản khách hàng</title>
    <link rel="stylesheet" href="styles.css">
</head>

<body>
    <div class="header">
        <h1>Đăng ký tài khoản khách hàng</h1>
    </div>
    <?php include('adminNav.php'); ?>
    <div class="form-container">
        <form method="POST" action="">
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            <div class="form-group">
                <label for="password">Mật khẩu:</label>
                <input type="password" id="password" name="password" required>
            </div>
            <div class="form-group">
                <label for="hoten">Họ tên:</label>
                <input type="text" id="hoten" name="hoten" required>
            </div>
            <div class="form-group">
                <label for="sdt">SĐT:</label>
                <input type="text" id="sdt" name="sdt" required>
            </div>
            <div class="form-group">
                <label for="gioitinh">Giới tính:</label>
                <select id="gioitinh" name="gioitinh">
                    <option value="Nam">Nam</option>
                    <option value="Nữ">Nữ</option>
                    <option value="">Chưa chọn</option>
                </select>
            </div>
            <div class="form-group">
                <label for="cccd">CCCD:</label>
                <input type="text" id="cccd" name="cccd" required>
            </div>
            <div class="form-group">
                <label for="diachi">Địa chỉ:</label>
                <textarea id="diachi" name="diachi" required></textarea>
            </div>
            <div class="form-group">
                <input type="submit" value="Đăng ký">
            </div>
            <?php if ($error): ?>
                <p class="error"><?php echo htmlspecialchars($error); ?></p>
            <?php endif; ?>
            <?php if ($success): ?>
                <p style="color: green;"><?php echo htmlspecialchars($success); ?></p>
            <?php endif; ?>
        </form>
    </div>
</body>

</html>